# Cursor Tools - 软件使用手册

<div align="center">
  <h2>🚀 专业的 Cursor IDE 账号管理工具</h2>
  <p>简单 · 强大 · 安全</p>
  
  [![Version](https://img.shields.io/badge/版本-v1.1.0-blue)](https://github.com/gacjie)
  [![Platform](https://img.shields.io/badge/平台-Windows-green)](https://github.com/gacjie)
  [![QQ Group](https://img.shields.io/badge/QQ群-866292271-orange)](https://qm.qq.com/cgi-bin/qr?k=866292271)
</div>

---

## 📖 目录

- [软件简介](#-软件简介)
- [系统要求](#-系统要求)
- [安装与启动](#-安装与启动)
- [界面介绍](#-界面介绍)
- [功能详解](#-功能详解)
  - [仪表盘](#1-仪表盘)
  - [账号管理](#2-账号管理)
  - [获取令牌](#3-获取令牌)
  - [实用工具](#4-实用工具)
  - [配置备份](#5-配置备份)
  - [Cursor 设置](#6-cursor-设置)
- [常见问题](#-常见问题)
- [注意事项](#-注意事项)
- [联系我们](#-联系我们)

---

## 🎯 软件简介

**Cursor Tools** 是一款专为 Cursor IDE 打造的账号管理工具，帮助您：

- ✅ **轻松管理多个 Cursor 账号** - 一键切换，无需反复登录
- ✅ **自动获取账号令牌** - 无需手动复制粘贴
- ✅ **安全存储账号信息** - 所有数据仅保存在本地，不上传云端
- ✅ **备份恢复配置** - 防止配置丢失，轻松迁移
- ✅ **管理机器码** - 完整的设备识别码管理功能

### ✨ 为什么选择 Cursor Tools？

| 功能 | 手动操作 | 使用 Cursor Tools |
|-----|---------|------------------|
| 切换账号 | 需要重新登录，输入邮箱密码 | 点击一次，自动切换 ✅ |
| 获取令牌 | 查找浏览器调试工具，手动复制 | 自动获取，一键保存 ✅ |
| 管理多账号 | 记在本子上，容易忘记 | 统一管理，清晰展示 ✅ |
| 备份配置 | 手动查找文件，复制粘贴 | 一键备份，一键恢复 ✅ |

---

## 💻 系统要求

### 最低配置

| 项目 | 要求 |
|-----|------|
| **操作系统** | Windows 10 及以上 |
| **Cursor IDE** | 需要已安装 Cursor IDE |
| **内存** | 512MB 可用内存 |
| **磁盘空间** | 100MB 可用空间 |
| **屏幕分辨率** | 1280x720 及以上 |

### 推荐配置

| 项目 | 推荐 |
|-----|------|
| **操作系统** | Windows 11 |
| **内存** | 1GB+ 可用内存 |
| **磁盘空间** | 500MB+ 可用空间 |

---

## 📦 安装与启动

### 方式一：直接运行（推荐）

1. **下载软件**
   - 下载 `CursorTools.exe` 文件
   - 建议放在一个固定的文件夹中（例如：`D:\Software\CursorTools\`）

2. **首次运行**
   - 双击 `CursorTools.exe` 启动软件
   
3. **处理安全提示**
   
   如果遇到 Windows Defender SmartScreen 警告：
   
   ![Windows 警告](https://via.placeholder.com/600x200/FF9800/FFFFFF?text=Windows+Defender+SmartScreen)
   
   ✅ **这是正常现象** - 因为软件是新发布的，还未建立 Windows 信誉
   
   **解决方法：**
   ```
   1. 点击 "更多信息"
   2. 点击 "仍要运行"
   3. 软件即可正常启动
   ```

4. **创建快捷方式（可选）**
   - 右键点击 `CursorTools.exe`
   - 选择 "发送到" → "桌面快捷方式"
   - 以后可以从桌面快速启动

### 方式二：添加到系统信任列表

如果不想每次都看到安全警告：

1. 打开 **Windows 安全中心**
2. 选择 **病毒和威胁防护**
3. 点击 **管理设置**
4. 在 **排除项** 中添加 `CursorTools.exe` 的路径

### 软件数据位置

软件运行后，会在以下位置创建数据文件：

```
📁 C:\Users\你的用户名\AppData\Roaming\CursorTools\
   ├── 📄 account.db        # 账号数据库
   ├── 📄 config.json       # 应用配置
   ├── 📄 proxy.json        # 代理配置
   └── 📁 config_backups\   # 配置备份文件夹
```

⚠️ **重要提示：** 卸载软件前，如需保留数据，请备份此文件夹！

---

## 🎨 界面介绍

### 主界面布局

```
┌─────────────────────────────────────────────────────────────┐
│  Cursor Tools                              [主题] [—] [□] [×] │ ← 标题栏
├──────────┬──────────────────────────────────────────────────┤
│          │                                                   │
│  📊 仪表盘 │                                                   │
│  👤 账号管理│                                                   │
│  🔑 获取令牌│                 主内容区域                          │
│  🛠️ 实用工具│                                                   │
│  💾 配置备份│                                                   │
│  ⚙️  设置   │                                                   │
│  ℹ️  关于   │                                                   │
│          │                                                   │
│  v1.1.0  │                                                   │
│  [展开]   │                                                   │
└──────────┴──────────────────────────────────────────────────┘
   侧边栏           内容区域
```

### 主题切换

软件支持 **亮色** 和 **暗色** 两种主题：

- 🌞 **亮色主题** - 简洁明快，适合白天使用
- 🌙 **暗色主题** - 护眼舒适，适合夜间使用

**切换方法：** 点击标题栏右上角的主题切换按钮（☀️/🌙）

---

## 🎯 功能详解

## 1. 仪表盘

### 功能说明

仪表盘是软件的"驾驶舱"，实时显示 Cursor IDE 的状态和当前账号信息。

### 界面内容

#### 📊 Cursor 状态
- **安装状态** - 检测 Cursor IDE 是否已安装
- **运行状态** - 实时显示 Cursor 是否正在运行
- **客户端版本** - 显示 Cursor IDE 的版本号

#### 👤 当前账号信息
- **邮箱地址** - 当前登录的账号邮箱
- **套餐类型** - Free（免费版）/ Pro（专业版）/ Free Trial（试用版）
- **认证状态** - 已认证 / 未认证
- **访问令牌** - Access Token（部分显示）

#### 🔧 机器码信息
- **Machine ID** - 设备唯一标识符
- **Service Machine ID** - 服务机器标识
- **Dev Device ID** - 开发设备标识
- **Mac Machine ID** - MAC 机器标识
- **Telemetry Machine ID** - 遥测机器标识
- **SQM ID** - 软件质量指标标识

### 操作按钮

#### 💾 保存账号
将当前 Cursor IDE 中的账号信息保存到本地数据库中。

**使用场景：**
- 首次使用软件，保存当前已登录的账号
- 在 Cursor 中手动登录新账号后，保存该账号

**操作步骤：**
```
1. 在 Cursor IDE 中登录账号
2. 打开 Cursor Tools
3. 在仪表盘点击 "💾 保存账号"
4. 确认保存
```

⚠️ **注意：** 如果账号已存在，会提示是否更新信息。

#### 🔄 刷新数据
重新读取 Cursor IDE 的数据，更新仪表盘显示。

**使用场景：**
- Cursor 状态发生变化（启动/关闭）
- 在 Cursor 中切换了账号
- 数据显示不正确时

### 使用技巧

1. **查看完整令牌**
   - 点击 Access Token 右侧的 "👁️ 显示" 按钮
   - 可复制完整令牌

2. **快速诊断问题**
   - 如果仪表盘显示"未安装"，检查 Cursor IDE 是否正确安装
   - 如果显示"未登录"，需要先在 Cursor 中登录账号

---

## 2. 账号管理

### 功能说明

账号管理是软件的核心功能，让您轻松管理和切换多个 Cursor 账号。

### 界面说明

账号列表以表格形式展示所有已保存的账号：

| 列名 | 说明 |
|-----|------|
| **邮箱** | 账号的邮箱地址 |
| **套餐** | Free / Pro / Free Trial（带颜色标签） |
| **使用量** | 已使用/总限额（如：10/500） |
| **到期时间** | 套餐到期日期 |
| **状态** | 账号状态（正常/过期/未知） |
| **更新时间** | 最后更新时间 |
| **操作** | 切换/编辑/删除按钮 |

**🌟 当前账号** - 正在使用的账号会用特殊标记高亮显示

### 功能操作

#### ➕ 添加账号

**方法一：从仪表盘保存（推荐）**
```
1. 在 Cursor IDE 中登录账号
2. 切换到 "📊 仪表盘"
3. 点击 "💾 保存账号"
```

**方法二：手动添加**
```
1. 点击账号管理页面的 "➕ 添加账号"
2. 填写必填信息：
   - 邮箱地址
   - Access Token
   - Refresh Token
3. 机器码留空（自动生成）或手动填写
4. 点击 "确定" 保存
```

#### 🔄 切换账号

这是软件最常用的功能！

**操作步骤：**
```
1. 在账号列表中找到要切换的账号
2. 点击该账号右侧的 "🔄 切换" 按钮
3. 确认切换操作
4. 完全关闭 Cursor IDE（重要！）
5. 重新打开 Cursor IDE
6. 新账号已生效 ✅
```

⚠️ **重要提示：**
- 必须完全关闭 Cursor IDE（不是最小化）
- 关闭方法：右键任务栏图标 → "退出"，或 任务管理器 → 结束进程
- 切换后第一次打开 Cursor 可能需要几秒钟加载

#### ✏️ 编辑账号

更新账号的信息（令牌、机器码等）。

**操作步骤：**
```
1. 点击账号右侧的 "✏️ 编辑" 按钮
2. 修改需要更新的字段
3. 点击 "确定" 保存
```

**使用场景：**
- 令牌过期，需要更新 Access Token
- 想要更换机器码
- 添加或修改备注信息

#### 🗑️ 删除账号

从本地数据库中删除不需要的账号。

**操作步骤：**
```
1. 点击账号右侧的 "🗑️ 删除" 按钮
2. 确认删除（不可恢复！）
```

⚠️ **注意：** 删除仅从软件数据库中删除，不影响 Cursor 官方账号。

#### 🔄 批量刷新

一键更新所有账号的套餐信息、使用量等数据。

**操作步骤：**
```
1. 点击顶部的 "🔄 批量刷新" 按钮
2. 等待刷新完成（会显示进度）
3. 查看更新后的账号信息
```

**刷新内容：**
- 套餐类型（Free/Pro/Trial）
- 使用量和总限额
- 到期时间
- 账号状态

⏱️ **刷新时间：** 视账号数量而定，通常每个账号 1-2 秒

#### 📥 导入账号

从 JSON 文件批量导入账号。

**操作步骤：**
```
1. 点击 "📥 导入账号"
2. 选择 JSON 格式的账号文件
3. 自动导入（重复账号会提示是否更新）
4. 查看导入结果
```

**JSON 文件格式示例：**
```json
[
  {
    "email": "example@gmail.com",
    "accessToken": "your_access_token",
    "refreshToken": "your_refresh_token",
    "plan": "pro"
  }
]
```

#### 📤 导出账号

将账号数据导出为 JSON 文件，便于备份或迁移。

**操作步骤：**
```
1. 选择要导出的账号（多选：按住 Ctrl 点击）
2. 不选则导出全部账号
3. 点击 "📤 导出账号"
4. 选择保存位置
5. 输入文件名，保存
```

**使用场景：**
- 备份账号数据
- 迁移到其他电脑
- 分享给朋友（注意安全！）

### 使用技巧

1. **快速识别当前账号**
   - 当前使用的账号会有 "🌟" 标记
   - 背景颜色也会略有不同

2. **套餐类型颜色标识**
   - 🟢 **Pro** - 绿色标签
   - 🔵 **Free Trial** - 蓝色标签
   - ⚪ **Free** - 灰色标签

3. **定期批量刷新**
   - 建议每周刷新一次，保持数据准确
   - Pro 用户可以看到使用量，避免超额

---

## 3. 获取令牌

### 功能说明

通过浏览器自动登录，获取 Cursor 账号的 Access Token 和 Refresh Token，省去手动查找的麻烦。

### 技术原理

本功能使用 **PKCE (Proof Key for Code Exchange)** 授权流程，这是 OAuth 2.0 的安全扩展：

```
用户 → 浏览器登录 → Cursor 授权服务器 → 返回授权码 → 软件交换令牌
```

✅ **安全可靠** - 符合 OAuth 2.0 标准，不经过第三方服务器

### 操作步骤

#### 步骤 1：生成登录链接

```
1. 打开 "🔑 获取令牌" 页面
2. 点击 "🌐 生成登录链接" 按钮
3. 软件会生成一个唯一的授权链接
4. 自动打开默认浏览器
```

#### 步骤 2：浏览器登录

```
1. 在打开的浏览器页面中登录 Cursor 账号
2. 可以选择以下登录方式：
   - Google 账号
   - GitHub 账号
   - 邮箱验证码
3. 完成登录授权
```

#### 步骤 3：开始轮询

```
1. 返回 Cursor Tools
2. 点击 "🔄 开始轮询" 按钮
3. 软件会自动检测登录状态
4. 等待获取令牌（通常 5-30 秒）
```

#### 步骤 4：保存账号

```
1. 令牌获取成功后，会显示：
   - 邮箱地址
   - 套餐类型
   - Access Token
   - Refresh Token
   - 自动生成的机器码
2. 点击 "💾 保存到数据库" 按钮
3. 账号自动保存到账号管理中
```

### 状态说明

| 状态 | 说明 |
|-----|------|
| **等待登录...** | 已生成链接，等待在浏览器中登录 |
| **轮询中...** | 正在检测登录状态 |
| **获取成功** | 令牌已获取 ✅ |
| **登录超时** | 超过 5 分钟未登录 |
| **获取失败** | 网络错误或授权失败 |

### 常见问题

**Q1：生成链接后，浏览器没有自动打开？**
- A：手动复制显示的链接，粘贴到浏览器中打开

**Q2：轮询一直显示"等待登录"？**
- A：检查是否在浏览器中完成了登录授权
- A：确认网络连接正常
- A：重新生成登录链接再试

**Q3：提示"账号已存在"？**
- A：该邮箱已保存，可以选择更新信息或取消

**Q4：获取的令牌能用多久？**
- A：Access Token 通常 24 小时有效
- A：Refresh Token 可以用来刷新 Access Token
- A：软件会自动处理令牌刷新

### 使用技巧

1. **一次获取，长期使用**
   - 获取后的账号会保存在数据库中
   - 以后直接在 "账号管理" 中切换即可

2. **批量获取账号**
   - 可以多次使用此功能
   - 为不同的邮箱账号获取令牌

3. **安全建议**
   - 获取后请妥善保管账号数据
   - 不要将令牌分享给他人

---

## 4. 实用工具

### 功能说明

提供一系列实用的 Cursor IDE 管理工具，包括机器码生成、配置清理等。

### 功能列表

#### 🆔 机器码生成器

生成 Cursor 所需的各种机器识别码。

**支持的机器码类型：**

| 机器码类型 | 说明 | 格式 |
|----------|------|------|
| **Machine ID** | 主机器标识 | UUID 格式 |
| **Service Machine ID** | 服务机器标识 | 与 Machine ID 相同 |
| **Dev Device ID** | 开发设备标识 | UUID 格式 |
| **Mac Machine ID** | MAC 机器标识 | UUID 格式 |
| **Telemetry Machine ID** | 遥测标识 | SHA256 哈希 |
| **SQM ID** | 软件质量标识 | 大写 UUID with braces |

**操作方式：**

1. **生成单个机器码**
   ```
   1. 点击对应机器码右侧的 "🎲 生成" 按钮
   2. 立即生成新的机器码
   3. 可以点击 "📋" 按钮复制
   ```

2. **生成全部机器码**
   ```
   1. 点击 "🎲 生成全部机器码" 按钮
   2. 一次性生成所有机器码
   3. 自动应用到 Cursor IDE
   ```

3. **应用到 Cursor**
   ```
   1. 点击 "✅ 应用到 Cursor" 按钮
   2. 将生成的机器码写入 Cursor 配置文件
   3. 重启 Cursor 生效
   ```

#### 🔄 重置机器码

将 Cursor IDE 的所有机器码重置为新值。

**操作步骤：**
```
1. 点击 "🔄 重置机器码" 按钮
2. 确认重置操作（不可恢复！）
3. 软件自动生成新的机器码
4. 自动应用到 Cursor
5. 重启 Cursor IDE
```

**使用场景：**
- 更换设备后，需要新的机器码
- 机器码被封禁，需要重置
- 测试不同机器码的效果

⚠️ **警告：** 重置机器码可能导致某些 Cursor 功能需要重新初始化。

#### 🧹 清理 Cursor 配置

清空 Cursor IDE 的配置文件，恢复到初始状态。

**操作步骤：**
```
1. 完全关闭 Cursor IDE
2. 点击 "🧹 清理 Cursor 配置"
3. 确认清理操作
4. 等待清理完成
```

**清理内容：**
- 账号登录信息
- 机器码信息
- 认证状态

⚠️ **注意：** 不会删除 Cursor 的安装文件和扩展。

#### 🗑️ 清理 Cursor 缓存

清理 Cursor IDE 的缓存文件，释放磁盘空间。

**操作步骤：**
```
1. 完全关闭 Cursor IDE
2. 点击 "🗑️ 清理 Cursor 缓存"
3. 确认清理操作
4. 等待清理完成
```

**清理内容：**
- 临时文件
- 日志文件
- 缓存数据

💾 **效果：** 通常可以释放 100MB - 1GB 的磁盘空间。

### 使用技巧

1. **清理前先备份**
   - 执行清理操作前，建议先在 "配置备份" 中创建备份
   - 如果出现问题，可以快速恢复

2. **重启 Cursor 后检查**
   - 清理或重置后，打开 Cursor 检查功能是否正常
   - 如有问题，可以使用 "配置备份" 恢复

3. **定期清理缓存**
   - 建议每月清理一次缓存
   - 可以保持 Cursor 运行流畅

---

## 5. 配置备份

### 功能说明

完整备份 Cursor IDE 的配置文件，支持一键恢复，防止配置丢失或方便迁移到新电脑。

### 备份内容

软件会备份以下 Cursor 配置文件：

| 文件/目录 | 说明 |
|---------|------|
| **state.vscdb** | 状态数据库（账号、认证信息） |
| **storage.json** | 存储配置（机器码、遥测信息） |
| **machineid** | 机器标识文件 |
| **settings.json** | Cursor 设置 |
| **mcp.json** | MCP 配置（如果存在） |

### 创建备份

#### 操作步骤

```
1. 打开 "💾 配置备份" 页面
2. 点击 "📦 创建新备份" 按钮
3. 输入备份信息：
   - 备份名称（必填）- 例如："切换账号前备份"
   - 备份描述（可选）- 例如："包含 Pro 账号配置"
4. 点击 "确定" 开始备份
5. 等待备份完成（通常 1-3 秒）
```

#### 备份文件位置

```
C:\Users\你的用户名\AppData\Roaming\CursorTools\config_backups\
   ├── 📁 2025-11-03_14-30-00_备份名称\
   │   ├── 📄 state.vscdb
   │   ├── 📄 storage.json
   │   ├── 📄 machineid
   │   ├── 📄 settings.json
   │   └── 📄 backup_info.json
   └── 📁 其他备份...
```

### 备份列表

备份列表会显示所有已创建的备份：

| 列名 | 说明 |
|-----|------|
| **备份名称** | 创建时输入的名称 |
| **备份描述** | 备份说明 |
| **创建时间** | 备份的创建日期和时间 |
| **文件数量** | 包含的文件数量 |
| **大小** | 备份文件的总大小 |
| **操作** | 恢复/删除按钮 |

### 恢复备份

#### 操作步骤

```
1. 完全关闭 Cursor IDE（重要！）
2. 在备份列表中选择要恢复的备份
3. 点击 "🔄 恢复" 按钮
4. 确认恢复操作
5. 等待恢复完成
6. 重新启动 Cursor IDE
7. 配置已恢复 ✅
```

#### 恢复前检查

软件会自动检查：
- ✅ Cursor IDE 是否已关闭
- ✅ 备份文件是否完整
- ✅ 目标路径是否有写入权限

如果检查失败，会提示具体问题和解决方法。

### 删除备份

删除不再需要的备份文件。

**操作步骤：**
```
1. 选择要删除的备份
2. 点击 "🗑️ 删除" 按钮
3. 确认删除（不可恢复！）
```

### 使用场景

#### 场景 1：切换账号前备份

```
1. 创建备份（名称："切换前-原账号"）
2. 切换到新账号
3. 如果新账号有问题，恢复备份
```

#### 场景 2：测试配置

```
1. 备份当前正常配置
2. 修改 Cursor 设置或机器码
3. 测试效果
4. 如果不满意，恢复备份
```

#### 场景 3：迁移到新电脑

```
旧电脑：
1. 创建配置备份
2. 导出账号数据（账号管理 → 导出）
3. 将 config_backups 文件夹复制到 U 盘

新电脑：
1. 安装 Cursor Tools
2. 复制 config_backups 文件夹到对应位置
3. 在软件中恢复备份
4. 导入账号数据
```

#### 场景 4：定期备份

建议每周创建一次备份，命名方式：
- "2025-11-03 周备份"
- "月度备份-11月"

### 使用技巧

1. **备份命名规范**
   - 使用日期 + 说明：`2025-11-03_Pro账号配置`
   - 使用场景 + 版本：`正常配置_v1`

2. **定期清理旧备份**
   - 保留最近 5-10 个备份即可
   - 旧备份占用空间不大，但过多会影响查找

3. **重要备份标注**
   - 在描述中标注 "⭐ 重要"
   - 不要轻易删除

---

## 6. Cursor 设置

### 功能说明

管理 Cursor IDE 的 `settings.json` 配置文件，支持常用设置的快速修改。

### 界面说明

#### 设置信息面板

显示当前 Cursor 设置的基本信息：

- 📁 **配置文件路径** - settings.json 的位置
- 📊 **文件大小** - 配置文件大小
- 🕐 **最后修改时间** - 文件的最后更新时间

#### 设置编辑器

- 支持 JSON 格式的语法高亮
- 可以直接编辑配置内容
- 自动格式化

### 功能操作

#### 🔄 刷新数据

重新读取 Cursor 的 settings.json 文件。

**使用场景：**
- 在 Cursor 中修改了设置
- 需要查看最新的配置

#### 💾 保存设置

将编辑器中的内容保存到 Cursor 的配置文件。

**操作步骤：**
```
1. 在编辑器中修改配置
2. 点击 "💾 保存设置"
3. 确认保存
4. 重启 Cursor IDE（如需要）
```

⚠️ **注意：** 请确保 JSON 格式正确，否则可能导致 Cursor 无法启动。

#### 🔄 重置为默认

将 Cursor 设置恢复到默认状态。

**操作步骤：**
```
1. 点击 "🔄 重置为默认"
2. 确认重置（不可恢复！）
3. Cursor 设置已重置为空配置
```

#### 📋 复制配置

将当前配置复制到剪贴板。

**使用场景：**
- 分享配置给他人
- 备份配置到文本文件

#### 📂 打开配置文件

在文件资源管理器中打开 settings.json 所在的文件夹。

### 常用设置示例

#### 设置代理

```json
{
  "http.proxy": "http://127.0.0.1:7890",
  "http.proxyStrictSSL": false
}
```

#### 设置字体

```json
{
  "editor.fontSize": 14,
  "editor.fontFamily": "Consolas, 'Courier New', monospace"
}
```

#### 禁用遥测

```json
{
  "telemetry.telemetryLevel": "off"
}
```

### 使用技巧

1. **修改前先备份**
   - 在 "配置备份" 中创建备份
   - 或点击 "📋 复制配置" 保存到文本文件

2. **使用 JSON 验证工具**
   - 可以在 https://jsonlint.com/ 验证 JSON 格式
   - 避免格式错误导致 Cursor 无法启动

3. **常用设置保存为模板**
   - 将常用配置保存到本地文件
   - 需要时复制粘贴

---

## ❓ 常见问题

### 安装与启动

#### Q1：首次运行提示"Windows 已保护你的电脑"？

**A：** 这是正常现象，因为软件是新发布的。

**解决方法：**
```
1. 点击 "更多信息"
2. 点击 "仍要运行"
```

**永久解决：** 将软件添加到 Windows Defender 白名单。

---

#### Q2：软件无法启动，双击无反应？

**A：** 可能的原因和解决方法：

1. **缺少运行时库**
   - 安装 [Microsoft Visual C++ Redistributable](https://aka.ms/vs/17/release/vc_redist.x64.exe)

2. **被杀毒软件拦截**
   - 检查杀毒软件是否拦截了 CursorTools.exe
   - 将软件添加到杀毒软件白名单

3. **权限问题**
   - 右键软件 → "以管理员身份运行"

---

#### Q3：软件界面显示不完整或者很小？

**A：** 高分辨率屏幕（如 4K）可能出现缩放问题。

**解决方法：**
```
1. 右键 CursorTools.exe
2. 选择 "属性"
3. 切换到 "兼容性" 标签
4. 点击 "更改高 DPI 设置"
5. 勾选 "替代高 DPI 缩放行为"
6. 选择 "系统(增强)"
7. 确定保存
```

---

### 账号管理

#### Q4：切换账号后，Cursor 中的账号没有变化？

**A：** 切换账号后必须完全关闭并重启 Cursor IDE。

**正确的操作流程：**
```
1. 在软件中切换账号
2. 右键任务栏的 Cursor 图标 → "退出"
   或打开任务管理器 → 找到 Cursor 进程 → 结束进程
3. 等待 3-5 秒
4. 重新打开 Cursor IDE
5. 检查账号是否已切换
```

**如果仍未切换：**
- 检查是否有多个 Cursor 进程在运行
- 注销 Windows 账户后重新登录
- 重启电脑

---

#### Q5：提示"Cursor 数据库不存在"？

**A：** 可能的原因：

1. **Cursor IDE 未安装**
   - 下载并安装 Cursor IDE

2. **Cursor 安装路径不正确**
   - 软件默认路径：`C:\Users\你的用户名\AppData\Roaming\Cursor`
   - 检查该路径是否存在

3. **Cursor 从未启动过**
   - 启动一次 Cursor IDE，让其生成必要的数据文件

---

#### Q6：切换账号后提示"数据库被占用"？

**A：** Cursor IDE 仍在运行，占用了数据库文件。

**解决方法：**
```
1. 打开任务管理器（Ctrl + Shift + Esc）
2. 找到所有 Cursor 相关进程
3. 全部结束进程
4. 等待 10 秒
5. 重新切换账号
```

---

### 获取令牌

#### Q7：生成登录链接后，浏览器没有自动打开？

**A：** 手动复制链接到浏览器。

**操作方法：**
```
1. 点击生成的链接右侧的 "📋 复制" 按钮
2. 打开浏览器（Chrome、Edge 等）
3. 粘贴链接到地址栏
4. 回车访问
```

---

#### Q8：轮询一直显示"等待登录"？

**A：** 可能的原因和解决方法：

1. **未在浏览器中完成登录**
   - 检查浏览器是否登录成功
   - 确认已完成授权操作

2. **网络问题**
   - 检查网络连接
   - 尝试使用代理或 VPN

3. **登录超时**
   - 重新生成登录链接
   - 更快地完成浏览器登录（5 分钟内）

---

#### Q9：获取令牌失败，提示"网络错误"？

**A：** 网络连接问题。

**解决方法：**
```
1. 检查网络连接
2. 如果使用代理，检查代理设置
3. 尝试使用其他网络（如手机热点）
4. 关闭 VPN 后重试
```

---

### 配置备份

#### Q10：恢复备份失败，提示"无法访问文件"？

**A：** Cursor IDE 仍在运行。

**解决方法：**
```
1. 完全关闭 Cursor IDE
2. 确保所有 Cursor 进程都已结束
3. 重新尝试恢复备份
```

---

#### Q11：备份文件丢失了怎么办？

**A：** 备份文件位于：

```
C:\Users\你的用户名\AppData\Roaming\CursorTools\config_backups\
```

如果整个文件夹被删除：
- 备份无法恢复
- 建议定期将 config_backups 文件夹复制到其他位置（如 D 盘、U 盘）

---

#### Q12：恢复备份后，Cursor 无法启动？

**A：** 可能备份文件已损坏。

**解决方法：**
```
1. 尝试恢复其他备份
2. 如果所有备份都无法使用：
   - 在软件中点击 "实用工具"
   - 点击 "🧹 清理 Cursor 配置"
   - 重新在 Cursor 中登录账号
```

---

### 实用工具

#### Q13：重置机器码后，Cursor 提示"设备未授权"？

**A：** 这是正常现象，新的机器码需要重新授权。

**解决方法：**
```
1. 在 Cursor 中重新登录账号
2. 完成邮箱验证
3. 设备授权完成
```

---

#### Q14：清理配置后，所有设置和扩展都丢失了？

**A：** "清理配置" 只清理账号和机器码信息，不会删除扩展。

如果扩展丢失：
- 扩展可能安装在其他位置
- 在 Cursor 中重新安装扩展

如果设置丢失：
- 使用 "配置备份" 恢复之前的设置
- 或手动重新配置

---

### 数据安全

#### Q15：软件会上传我的账号信息吗？

**A：** 不会！软件完全离线运行。

- ✅ 所有账号数据存储在本地数据库
- ✅ 不连接任何第三方服务器
- ✅ 仅在 "获取令牌" 时连接 Cursor 官方服务器

**数据存储位置：**
```
C:\Users\你的用户名\AppData\Roaming\CursorTools\
```

---

#### Q16：如何保护我的账号数据？

**A：** 安全建议：

1. **定期导出备份**
   - 在 "账号管理" 中导出账号数据
   - 保存到安全的位置（加密 U 盘、网盘）

2. **不要分享账号文件**
   - 包含 Access Token 的文件不要分享给他人
   - 他人可以使用你的令牌访问你的 Cursor 账号

3. **设置文件夹访问权限**
   - 对 CursorTools 文件夹设置访问密码
   - 防止他人访问

---

#### Q17：卸载软件后，数据会被删除吗？

**A：** 不会自动删除。

卸载软件只删除 `CursorTools.exe` 文件，数据仍保留在：
```
C:\Users\你的用户名\AppData\Roaming\CursorTools\
```

**如需完全卸载：**
```
1. 删除 CursorTools.exe
2. 删除 C:\Users\你的用户名\AppData\Roaming\CursorTools\ 文件夹
3. 完成
```

---

### 其他问题

#### Q18：软件支持 macOS 和 Linux 吗？

**A：** 目前仅支持 Windows 系统。

macOS 和 Linux 版本正在开发中，敬请期待。

---

#### Q19：软件占用多少系统资源？

**A：** 资源占用很低。

- **内存占用：** 50-100MB
- **CPU 占用：** 空闲时 0%，操作时 < 5%
- **磁盘占用：** 软件 ~50MB，数据 < 10MB

可以放心后台运行。

---

#### Q20：软件更新如何获取？

**A：** 更新方式：

1. **加入 QQ 群**
   - QQ 群号：866292271
   - 群文件中会发布最新版本

2. **关注项目主页**
   - GitHub：https://github.com/gacjie

3. **检查更新**
   - 打开软件，查看 "关于" 页面
   - 查看当前版本号
   - 与最新版本对比

---

## ⚠️ 注意事项

### 重要提示

#### 1. 账号切换

- ⚠️ 切换账号后**必须重启 Cursor IDE** 才能生效
- ⚠️ 切换前请保存 Cursor 中未保存的工作
- ⚠️ 完全关闭 Cursor（不是最小化）：右键任务栏图标 → "退出"

#### 2. 配置备份

- ⚠️ 恢复配置前请确保 Cursor IDE 已**完全关闭**
- ⚠️ 建议在重要操作前先创建备份
- ⚠️ 定期清理过期备份以节省空间
- ⚠️ 备份文件包含敏感信息，请妥善保管

#### 3. 数据安全

- ✅ 所有数据仅存储在本地计算机
- ✅ 不会上传任何信息到云端服务器
- ⚠️ 请妥善保管 Access Token 和 Refresh Token
- ⚠️ 不要将账号数据分享给他人
- ⚠️ 导出的 JSON 文件包含敏感信息

#### 4. 系统兼容性

- ✅ 仅支持 Windows 10/11 系统
- ✅ 支持 Cursor IDE 所有版本
- ⚠️ 部分功能可能因 Cursor 更新而需要适配
- ⚠️ 建议使用最新版本的 Cursor IDE

#### 5. 机器码管理

- ⚠️ 重置机器码可能影响某些 Cursor 功能
- ⚠️ Machine ID 和 Service Machine ID 必须保持一致
- ✅ 工具会自动确保机器码的一致性

### 最佳实践

#### 1. 定期备份

- 建议每周创建一次配置备份
- 重要操作前先创建备份
- 导出账号数据保存到安全位置

#### 2. 账号管理

- 为每个账号添加清晰的备注
- 定期清理不再使用的账号
- 使用批量刷新更新账号状态

#### 3. 安全建议

- 不要在公共电脑上保存账号
- 定期更新 Access Token
- 妥善保管账号导出文件
- 设置文件夹访问权限

#### 4. 性能优化

- 定期清理 Cursor 缓存
- 不要保存过多备份（5-10 个即可）
- 及时删除不用的账号

---

## 📞 联系我们

### 获取支持

如果您在使用过程中遇到问题，可以通过以下方式获取帮助：

#### 💬 QQ 交流群

**群号：866292271**

- 获取最新版本
- 反馈问题和建议
- 与其他用户交流使用经验
- 获得及时的技术支持

#### 🐛 问题反馈

在反馈问题时，请提供以下信息：

```
1. 软件版本号（查看 "关于" 页面）
2. 操作系统版本（如 Windows 11）
3. 问题描述
4. 复现步骤
5. 错误截图（如果有）
```

#### 💡 功能建议

欢迎提出功能建议和改进意见！

### 开发者信息

- 👨‍💻 **作者**：GacJie
- 🌐 **官网**：[www.wepool.vip](https://www.wepool.vip)
- 💻 **GitHub**：[github.com/gacjie](https://github.com/gacjie)

### 社区

欢迎加入我们的社区，与其他用户交流：

- 分享使用技巧和经验
- 反馈问题和建议
- 参与功能讨论
- 获取最新消息

---

## 📝 版本信息

**当前版本：v1.1.0**

### 更新日志

#### v1.1.0 (2025-11-03)

**新功能**
- ✨ 添加 Cursor 设置管理功能
- ✨ 支持账号批量刷新
- ✨ 添加账号状态显示（使用量、到期时间）
- ✨ 优化账号导入导出功能

**改进**
- 🎨 优化界面布局和交互
- ⚡ 提升配置备份速度
- 🐛 修复切换账号时的稳定性问题
- 🔧 优化数据库连接管理

#### v1.0.0 (2025-01-XX)

**首次发布**
- ✨ 实现完整的账号管理功能
- ✨ 支持令牌自动获取（PKCE 流程）
- ✨ 配置备份与恢复功能
- ✨ 机器码生成和管理
- ✨ 亮色/暗色主题切换

---

## 📄 许可协议

```
Copyright © 2025-2029 GacJie. All rights reserved.

Cursor Tools 是专有软件。未经授权，不得复制、修改、
分发本软件的任何部分。

保留所有权利。
```

### 免责声明

本软件按"现状"提供，不提供任何明示或暗示的保证。使用本软件的风险由用户自行承担。

- 软件开发者不对因使用本软件造成的任何损失负责
- 请确保在操作前备份重要数据
- 账号信息的安全由用户自行负责

---

## 🙏 致谢

感谢所有使用 Cursor Tools 的用户！

如果您觉得软件有帮助，欢迎：

- ⭐ 给项目点 Star
- 💬 加入 QQ 群交流
- 🔄 分享给朋友

---

<div align="center">
  <h3>🌟 让 Cursor IDE 管理更简单 🌟</h3>
  <p>感谢使用 Cursor Tools！</p>
  <p>如有问题，请加入 QQ 群：<b>866292271</b></p>
</div>

---

**最后更新时间：2025-11-03**
