# Augment Tools

Augment Tools 是一款使用 PySide6 开发的桌面应用程序，旨在帮助用户管理他们的 Augment 账号，并提供一个美观、现代化的用户界面。

## ✨ 功能特性

- **账号管理**:
  - **增删改查**: 轻松添加、编辑、删除和查看 Augment 账号。
  - **批量操作**: 支持批量刷新账号信息。
  - **导入/导出**: 以 JSON 格式方便地导入和导出账号列表。
- **安全的认证**:
  - **OAuth 2.0 PKCE**: 通过标准的 PKCE 流程安全获取访问令牌，无需在应用内存储密码。
- **系统监控**:
  - **实时仪表盘**: 动态展示 CPU、内存、磁盘使用率和当前运行进程数。
- **现代化的UI**:
  - **主题切换**: 内置浅色和深色两种主题，并支持一键切换。
  - **自定义界面**: 使用 QSS 和自定义绘制实现平滑、美观的 macOS 风格界面。
  - **无边框窗口**: 自定义标题栏，实现现代化窗口外观。

## 📝 使用方法

1.  **获取令牌**:
    -   打开应用，点击侧边栏的 "获取令牌"。
    -   点击 "生成链接" 按钮，应用将生成一个授权URL并自动复制到剪贴板。
    -   在浏览器中打开该链接，登录您的 Augment 账号并授权。
    -   授权成功后，浏览器会显示一个 JSON 对象。将此 JSON 完整复制。
    -   回到应用，将复制的 JSON 粘贴到 "输入回调数据" 的文本框中，然后点击 "交换令牌"。
    -   令牌交换成功后，输入您的 `Portal Token`（账单令牌）。
    -   点击 "保存账号"，您的账号信息将被保存到本地数据库。

2.  **管理账号**:
    -   在 "账号管理" 页面，您可以查看所有已添加的账号。
    -   使用 "刷新" 按钮更新单个或全部账号的余额、套餐等信息。
    -   通过 "编辑" 和 "删除" 按钮管理您的账号。
    -   使用 "导入" 和 "导出" 功能来备份或迁移您的账号数据。

